unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Memo1.Lines.LoadFromFile('unit1.pas');
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Linha : String;
begin
  Linha := '';
  if InputQuery('Nova linha no memo','Nova Linha:',Linha) then
  try
// seta linha
    With Memo1 do begin
      SelStart := Perform(EM_LINEINDEX, StrToInt(Linha), 0);
      SetFocus;
    end;
  except
    On EConvertError do
      MessageDlg('Nmero de linha invlido',mtError,[mbOk],0);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  ColStr : String;
  Linha,Coluna : Integer;
begin
  ColStr := '';
// Pega linha atual do memo
  with Memo1 do
    Linha := Perform(EM_LINEFROMCHAR,SelStart,0);
  if InputQuery('Nova coluna no memo','Nova Coluna:',ColStr) then
  try
// seta coluna
    With Memo1 do begin
      Coluna := StrToInt(ColStr);
// se coluna > tamanho da linha atual, coluna = tam.linha      
      if Coluna > Length(Lines[Linha]) then
        Coluna := Length(Lines[Linha]);
      SelStart := Coluna + Perform(EM_LINEINDEX, Linha, 0);
      SetFocus;
    end;
  except
    On EConvertError do
      MessageDlg('Nmero de coluna invlido',mtError,[mbOk],0);
  end;
end;

end.
